<?php
if (!defined("WHMCS"))
die("This file cannot be accessed directly");

use Illuminate\Database\Capsule\Manager as Capsule;

add_hook('ClientAreaPage', 1, function ($vars) 
{
//Make sure code executed only in homepage.tpl (index.php)
if (strpos($vars['SCRIPT_NAME'], 'index.php') !== false) {
    //Read products
    $products = Capsule::table('tblproducts')
                ->where('hidden', '0')
                ->orderBy('gid', 'name')
                ->get();

    //pass variables to the template
    $extra = array("products" => $products, "prdouctsLabel" => "Our Products");

    return $extra;
}


});

function product_details_additional_text_hook($vars)
{
    // Check if the product group is "Shared Hosting"
    if ($vars['groupname'] == "Shared Hosting") {
        // Modify the groupname
        $groupname = $vars['groupname']."<br>Brian's Special Department";
        return array("groupname" => $groupname);
    }
    return $vars;
}

// Target both the "Shared Hosting" group and the product details template
add_hook("ClientAreaProductDetailsPreModuleTemplate", 2, "product_details_additional_text_hook");
add_hook("ClientAreaProductDetails", 2, "product_details_additional_text_hook");