<section id="page-title">

    <div class="container clearfix">

        <h4 class="nobottommargin"><?php echo Format::htmlchars($thisclient->getName()); ?>&nbsp;&nbsp; |&nbsp;&nbsp; User Profile</h4>
        <ol class="breadcrumb">
            <li><a href="<?php echo ROOT_PATH; ?>index.php">Home &nbsp;&nbsp;</a></li>
            <li>/</li>
            <li class="active"><a href="<?php echo ROOT_PATH; ?>profile.php">&nbsp;&nbsp; User Profile</a></li>
        </ol>        

    </div>

</section><section id="content nobottommargin">

    <div class="content-wrap">

        <div class="container clearfix">

            <h3><?php echo __('Manage Your Profile Information'); ?></h3>
                <p><?php echo __(
                'Use the forms below to update the information we have on file for your account'
                ); ?>
                </p>

            <form action="profile.php" method="post">
              <?php csrf_token(); ?>

            <div>            
                <?php
                foreach ($user->getForms() as $f) {
                    $f->render(['staff' => false]);
                }
                if ($acct = $thisclient->getAccount()) {
                    $info=$acct->getInfo();
                    $info=Format::htmlchars(($errors && $_POST)?$_POST:$info);
                ?>
                <div class="content-wrap nopadding clearfix">
                    <div class="fancy-title title-border topmargin-sm">
                        <h4>Preferences</h4>
                    </div>
                        <label for="template-contactform-service">Time Zone</label>  
                    <div>
                        <?php
                        $TZ_NAME = 'timezone';
                        $TZ_TIMEZONE = $info['timezone'];
                        include INCLUDE_DIR.'staff/templates/timezone.tmpl.php'; ?>
                        <div class="error"><?php echo $errors['timezone']; ?></div>
                    </div>
                </div>

                <?php if ($cfg->getSecondaryLanguages()) { ?>
                    <tr>
                        <td width="180">
                            <?php echo __('Preferred Language'); ?>:
                        </td>
                        <td>
                    <?php
                    $langs = Internationalization::getConfiguredSystemLanguages(); ?>
                            <select name="lang">
                                <option value="">&mdash; <?php echo __('Use Browser Preference'); ?> &mdash;</option>
                <?php foreach($langs as $l) {
                $selected = ($info['lang'] == $l['code']) ? 'selected="selected"' : ''; ?>
                                <option value="<?php echo $l['code']; ?>" <?php echo $selected;
                                    ?>><?php echo Internationalization::getLanguageDescription($l['code']); ?></option>
                <?php } ?>
                            </select>
                            <span class="error">&nbsp;<?php echo $errors['lang']; ?></span>
                        </td>
                    </tr>
                <?php }
                      if ($acct->isPasswdResetEnabled()) { ?>

                <div class="content-wrap nopadding clearfix">
                    <div class="fancy-title title-border topmargin-sm">
                        <h4>Access Credentials</h4>
                    </div>        
                    
                        <?php if (!isset($_SESSION['_client']['reset-token'])) { ?>

                            <div>
                                <div class="col_one_third">
                                    <label for="template-contactform-name">Current Password *</label>
                                    <td>
                                        <input class="form-control" type="password" size="18" name="cpasswd" value="<?php echo $info['cpasswd']; ?>">
                                        &nbsp;<span class="error">&nbsp;<?php echo $errors['cpasswd']; ?></span>
                                    </td>
                                </div>

                                <?php } ?>


                                <div class="col_one_third">
                                    <label for="template-contactform-name">New Password *</label>
                                    <td>
                                        <input class="form-control" type="password" size="18" name="passwd1" value="<?php echo $info['passwd1']; ?>">
                                        &nbsp;<span class="error">&nbsp;<?php echo $errors['passwd1']; ?></span>
                                    </td>
                                </div>

                                <div class="col_one_third col_last">
                                    <label for="template-contactform-name">Confirm New Password *</label>
                                    <td>
                                        <input class="form-control" type="password" size="18" name="passwd2" value="<?php echo $info['passwd2']; ?>">
                                        &nbsp;<span class="error">&nbsp;<?php echo $errors['passwd2']; ?></span>
                                    </td>
                                </div>
                            </div>
                    <?php } ?>
                    <?php } ?>
                </div>    
            </div>

            <div class="clear"></div>
                <p style="text-align: center;">
                    <input class="button button-3d button-small button-rounded button-green" type="submit" value="Update"/>
                    <input class="button button-3d button-small button-rounded button-blue" type="reset" value="Reset"/>
                    <input class="button button-3d button-small button-rounded button" type="button" value="Cancel" onclick="javascript:
                        window.location.href='index.php';"/>
                </p>
            </div>  
        </form>
