<?php

namespace Database\Factories;

use App\Abstracts\Factory;
use App\Models\Auth\User as Model;
use Illuminate\Support\Str;

class User extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $password = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi'; // password

        return [
            'name' => $this->faker->name,
            'email' => $this->faker->freeEmail,
            'password' => $password,
            'password_confirmation' => $password,
            'remember_token' => Str::random(10),
            'locale' => 'en-GB',
            'companies' => ['1'],
            'roles' => '1',
            'enabled' => $this->faker->boolean ? 1 : 0,
            'created_from' => 'core::factory',
        ];
    }

    /**
     * Indicate that the model is enabled.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    public function enabled()
    {
        return $this->state([
            'enabled' => 1,
        ]);
    }

    /**
     * Indicate that the model is disabled.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    public function disabled()
    {
        return $this->state([
            'enabled' => 0,
        ]);
    }
}
