<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package mod_lesson
 * @copyright  1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['accesscontrol'] = 'Access control';
$string['actionaftercorrectanswer'] = 'Action after correct answer';
$string['actionaftercorrectanswer_help'] = 'After answering a question correctly, there are 3 options for the following page:

* Normal - Follow lesson path
* Show an unseen page - Pages are shown in a random order with no page shown twice
* Show an unanswered page - Pages are shown in a random order, with pages containing unanswered questions shown again';
$string['actions'] = 'Actions';
$string['activitylink'] = 'Link to next activity';
$string['activitylink_help'] = 'To provide a link at the end of the lesson to another activity in the course, select the activity from the drop-down menu.';
$string['activitylinkname'] = 'Go to {$a}';
$string['activityoverview'] = 'You have lessons that are due';
$string['addabranchtable'] = 'Add a content page';
$string['addanendofbranch'] = 'Add an end of branch';
$string['addanewpage'] = 'Add a new page';
$string['addaquestionpage'] = 'Add a question page';
$string['addaquestionpagehere'] = 'Add a question page here';
$string['addbranchtable'] = 'Add a content page';
$string['addcluster'] = 'Add a cluster';
$string['addessay'] = 'Create an Essay question page';
$string['addedabranchtable'] = 'Added a content page';
$string['addedanendofbranch'] = 'Added an end of branch';
$string['addedaquestionpage'] = 'Added a question page';
$string['addedcluster'] = 'Added a cluster';
$string['addedendofcluster'] = 'Added an end of cluster';
$string['addendofbranch'] = 'Add end of branch';
$string['addendofcluster'] = 'Add an end of cluster';
$string['addmatching'] = 'Create a Matching question page';
$string['addmultichoice'] = 'Create a Multichoice question page';
$string['addnewgroupoverride'] = 'Add group override';
$string['addnewuseroverride'] = 'Add user override';
$string['addnumerical'] = 'Create a Numerical question page';
$string['additionalattemptsremaining'] = 'Completed, You can re-attempt this lesson';
$string['addpage'] = 'Add a page';
$string['addshortanswer'] = 'Create a Short answer question page';
$string['addtruefalse'] = 'Create a True/false question page';
$string['allowofflineattempts'] = 'Allow lesson to be attempted offline using the mobile app';
$string['allowofflineattempts_help'] = 'If enabled, a mobile app user can download the lesson and attempt it offline.
All the possible answers and correct responses will be downloaded as well.
Note: It is not possible for a lesson to be attempted offline if it has a time limit.';
$string['and'] = 'AND';
$string['anchortitle'] = 'Start of main content';
$string['answer'] = 'Answer';
$string['answeredcorrectly'] = 'answered correctly.';
$string['answersfornumerical'] = 'Answers for numerical questions should be matched pairs of minimum and maximum values';
$string['arrangebuttonshorizontally'] = 'Arrange content buttons horizontally?';
$string['attempt'] = 'Attempt: {$a}';
$string['attemptheader'] = 'Attempt';
$string['attempts'] = 'Attempts';
$string['attemptsdeleted'] = 'Deleted attempts';
$string['attemptsremaining'] = 'You have {$a} attempt(s) remaining';
$string['available'] = 'Available from';
$string['averagescore'] = 'Average score';
$string['averagetime'] = 'Average time';
$string['branch'] = 'Content';
$string['branchtable'] = 'Content';
$string['cancel'] = 'Cancel';
$string['cannotfindanswer'] = 'Error: could not find answer';
$string['cannotfindattempt'] = 'Error: could not find attempt';
$string['cannotfindessay'] = 'Error: could not find essay';
$string['cannotfindfirstgrade'] = 'Error: could not find grades';
$string['cannotfindfirstpage'] = 'Could not find first page';
$string['cannotfindgrade'] = 'Error: could not find grades';
$string['cannotfindnewestgrade'] = 'Error: could not find newest grade';
$string['cannotfindnextpage'] = 'Lesson backup: Next page not found!';
$string['cannotfindpagerecord'] = 'Add end of branch: page record not found';
$string['cannotfindpages'] = 'Could not find lesson pages';
$string['cannotfindpagetitle'] = 'Confirm delete: page title not found';
$string['cannotfindpreattempt'] = 'Previous attempt record could not be found!';
$string['cannotfindrecords'] = 'Error: could not find lesson records';
$string['cannotfindtimer'] = 'Error: could not find lesson_timer records';
$string['cannotfinduser'] = 'Error: could not find users';
$string['canretake'] = '{$a} can re-take';
$string['casesensitive'] = 'Use regular expressions';
$string['casesensitive_help'] = 'Tick the checkbox to use regular expressions for analysing responses.';
$string['classstats'] = 'Class statistics';
$string['clicktodownload'] = 'Click on the following link to download the file.';
$string['closebeforeopen'] = 'Could not update the lesson. You have specified a close date before the open date.';
$string['cluster'] = 'Cluster';
$string['clusterjump'] = 'Unseen question within a cluster';
$string['clustertitle'] = 'Cluster';
$string['collapsed'] = 'Collapsed';
$string['comments'] = 'Your comments';
$string['completed'] = 'Completed';
$string['completederror'] = 'Complete the lesson';
$string['completethefollowingconditions'] = 'You must complete the following condition(s) in <b>{$a}</b> lesson before you can proceed.';
$string['completionendreached'] = 'Require end reached';
$string['completionendreached_desc'] = 'Student must reach the end of lesson page to complete this activity';
$string['completiontimespent'] = 'Student must do this activity at least for';
$string['completiontimespentdesc'] = 'Student must do this activity for at least {$a}';
$string['completiontimespentgroup'] = 'Require time spent';
$string['conditionsfordependency'] = 'Condition(s) for the dependency';
$string['configintro'] = 'The values set here define the default values that are used in the settings form when creating a new lesson activity. Settings specified as advanced are only shown when the \'Show more...\' link is clicked.';
$string['configmaxanswers'] = 'Default maximum number of answers per page';
$string['configmediaclose'] = 'Displays a close button as part of the popup generated for a linked media file';
$string['configmediaheight'] = 'Sets the height of the popup displayed for a linked media file';
$string['configmediawidth'] = 'Sets the width of the popup displayed for a linked media file';
$string['configpassword_desc'] = 'Whether a password is required in order to access the lesson.';
$string['configslideshowbgcolor'] = 'Background colour for the slideshow if it is enabled';
$string['configslideshowheight'] = 'Sets the height of the slideshow if it is enabled';
$string['configslideshowwidth'] = 'Sets the width of the slideshow if it is enabled';
$string['configtimelimit_desc'] = 'If a time limit is set, a warning is displayed at the beginning of the lesson and there is a countdown timer. If set to zero, then there is no time limit.';
$string['confirmdelete'] = 'Delete page';
$string['confirmdeletionofthispage'] = 'Confirm deletion of this page';
$string['congratulations'] = 'Congratulations - end of lesson reached';
$string['continue'] = 'Continue';
$string['continuetoanswer'] = 'Continue to change answers.';
$string['continuetonextpage'] = 'Continue to next page.';
$string['correctanswerjump'] = 'Correct answer jump';
$string['correctanswerscore'] = 'Correct answer score';
$string['correctresponse'] = 'Correct response';
$string['createaquestionpage'] = 'Create a question page';
$string['credit'] = 'Credit';
$string['customscoring'] = 'Custom scoring';
$string['customscoring_help'] = 'If enabled, then each answer may be given a numerical point value (positive or negative).';
$string['deadline'] = 'Deadline';
$string['defaultessayresponse'] = 'Your essay will be graded by your teacher.';
$string['deleteallattempts'] = 'Delete all lesson attempts';
$string['deletedefaults'] = 'Deleted {$a} x lesson default';
$string['deletedpage'] = 'Deleted page';
$string['deletepagenamed'] = 'Delete page: {$a}';
$string['deleting'] = 'Deleting';
$string['deletingpage'] = 'Deleting page: {$a}';
$string['dependencyon'] = 'Dependent on';
$string['dependencyon_help'] = 'This setting allows access to this lesson to be dependent upon a student\'s performance in another lesson in the same course. Any combination of time spent, completed or "grade better than" may be used.';
$string['description'] = 'Description';
$string['detailedstats'] = 'Detailed statistics';
$string['didnotanswerquestion'] = 'Did not answer this question.';
$string['didnotreceivecredit'] = 'Did not receive credit';
$string['disabled'] = 'Disabled';
$string['displaydefaultfeedback'] = 'Use default feedback';
$string['displaydefaultfeedback_help'] = 'If enabled, when a response is not found for a particular question, the default response of "That\'s the correct answer" or "That\'s the wrong answer" will be shown.';
$string['displayinleftmenu'] = 'Display in menu?';
$string['displayleftif'] = 'Minimum grade to display menu';
$string['displayleftif_help'] = 'This setting determines whether a student must obtain a certain grade before viewing the lesson menu. This forces the student to go through the entire lesson on their first attempt, then after obtaining the required grade they can use the menu for review.';
$string['displayleftmenu'] = 'Display menu';
$string['displayleftmenu_help'] = 'If enabled, a menu allowing users to navigate through the list of pages is displayed.';
$string['displayofgrade'] = 'Display of grade (for students only)';
$string['displayreview'] = 'Provide option to try a question again';
$string['displayreview_help'] = 'If enabled, when a question is answered incorrectly, the student is given the option to try it again for no point credit, or continue with the lesson.';
$string['displayscorewithessays'] = '<p>You earned {$a->score} out of {$a->tempmaxgrade} for the automatically graded questions.</p>
<p>Your {$a->essayquestions} essay question(s) will be graded and added into your final score at a later date.</p>
<p>Your current grade without the essay question(s) is {$a->score} out of {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'Your score is {$a->score} (out of {$a->grade}).';
$string['duplicatepagenamed'] = 'Duplicate page: {$a}';
$string['edit'] = 'Edit';
$string['editbranchtable'] = 'Editing a content page';
$string['editcluster'] = 'Editing a cluster';
$string['editendofcluster'] = 'Editing an end of cluster page';
$string['editendofbranch'] = 'Editing an end of branch page';
$string['editessay'] = 'Editing an Essay question page';
$string['editingquestionpage'] = 'Editing {$a} question page';
$string['editlessonsettings'] = 'Edit lesson settings';
$string['editmatching'] = 'Editing a Matching question page';
$string['editmultichoice'] = 'Editing a Multichoice question page';
$string['editnumerical'] = 'Editing a Numerical question page';
$string['editoverride'] = 'Edit override';
$string['editpage'] = 'Edit page contents';
$string['editpagecontent'] = 'Edit page contents';
$string['editquestion'] = 'Editing a question page';
$string['editshortanswer'] = 'Editing a Short answer question page';
$string['edittruefalse'] = 'Editing a True/false question page';
$string['email'] = 'Email';
$string['emailallgradedessays'] = 'Email ALL graded essays';
$string['emailgradedessays'] = 'Email graded essays';
$string['emailsuccess'] = 'Emails sent successfully';
$string['enabled'] = 'Enabled';
$string['endofbranch'] = 'End of branch';
$string['endofcluster'] = 'End of cluster';
$string['endofclustertitle'] = 'End of cluster';
$string['endoflesson'] = 'End of lesson';
$string['enteredthis'] = 'entered this.';
$string['enterpassword'] = 'Please enter the password:';
$string['emptypassword'] = 'Password cannot be empty';
$string['eolstudentoutoftime'] = 'Attention:  You ran out of time for this lesson.  Your last answer may not have counted if it was answered after the time was up.';
$string['eolstudentoutoftimenoanswers'] = 'You did not answer any questions.  You have received a 0 for this lesson.';
$string['essay'] = 'Essay';
$string['essayemailmessage2'] = '<p>Essay prompt: {$a->question}</p><p>Your response: <em>{$a->response}</em></p><p>Grader\'s comments: <em>{$a->comment}</em></p><p>You have received {$a->earned} out of {$a->outof} for this essay question.</p><p>Your grade for the {$a->lesson} lesson has been changed to {$a->newgrade}&#37;.</p>';
$string['essayemailsubject'] = 'Grade available for lesson question';
$string['essaynotgradedyet'] = 'This essay has not been graded yet';
$string['essayresponses'] = 'Essay responses';
$string['essays'] = 'Essays';
$string['essayscore'] = 'Essay score';
$string['eventcontentpageviewed'] = 'Content page viewed';
$string['eventessayassessed'] = 'Essay assessed';
$string['eventessayattemptviewed'] = 'Essay attempt viewed';
$string['eventlessonended'] = 'Lesson ended';
$string['eventlessonrestarted'] = 'Lesson restarted';
$string['eventlessonresumed'] = 'Lesson resumed';
$string['eventlessonstarted'] = 'Lesson started';
$string['eventoverridecreated'] = 'Lesson override created';
$string['eventoverridedeleted'] = 'Lesson override deleted';
$string['eventoverrideupdated'] = 'Lesson override updated';
$string['eventpagecreated'] = 'Page created';
$string['eventpagemoved'] = 'Page moved';
$string['eventpageupdated'] = 'Page updated';
$string['eventpagedeleted'] = 'Page deleted';
$string['eventquestionanswered'] = 'Question answered';
$string['eventquestionviewed'] = 'Question viewed';
$string['false'] = 'False';
$string['fileformat'] = 'File format';
$string['finalwrong'] = 'Not quite.';
$string['finish'] = 'Finish';
$string['firstanswershould'] = 'First answer should jump to the "Correct" page';
$string['firstwrong'] = 'You have answered incorrectly. Would you like to attempt the question again? (If you now answer the question correctly, it will not count towards your final score.)';
$string['flowcontrol'] = 'Flow control';
$string['fractionsaddwrong'] = 'The positive grades you have chosen do not add up to 100%<br />Instead, they add up to {$a}%<br />Do you want to go back and fix this question?';
$string['fractionsnomax'] = 'One of the answers should be 100%, so that it is<br />possible to get a full grade for this question.<br />Do you want to go back and fix this question?';
$string['full'] = 'Expanded';
$string['general'] = 'General';
$string['gotoendoflesson'] = 'Go to the end of the lesson';
$string['grade'] = 'Grade';
$string['gradebetterthan'] = 'Grade better than (&#37;)';
$string['gradebetterthanerror'] = 'Earn a grade better than {$a} percent';
$string['graded'] = 'Graded';
$string['gradeessay'] = 'Grade essay questions ({$a->notgradedcount} not graded and {$a->notsentcount} not sent)';
$string['gradeis'] = 'Grade is {$a}';
$string['gradeoptions'] = 'Grade options';
$string['groupoverrides'] = 'Group overrides';
$string['groupoverridesdeleted'] = 'Group overrides deleted';
$string['groupsnone'] = 'No groups you can access.';
$string['handlingofretakes'] = 'Handling of re-takes';
$string['handlingofretakes_help'] = 'If re-takes are allowed, this setting specifies whether the grade for the lesson is the mean or maximum of all attempts.';
$string['havenotgradedyet'] = 'Have not graded yet.';
$string['here'] = 'here';
$string['highscore'] = 'High score';
$string['hightime'] = 'High time';
$string['checkbranchtable'] = 'Check content page';
$string['checkedthisone'] = 'Checked this one.';
$string['checknavigation'] = 'Check navigation';
$string['checkquestion'] = 'Check question';
$string['importcount'] = 'Importing {$a} questions';
$string['importquestions'] = 'Import questions';
$string['importquestions_help'] = 'This feature enables questions in a variety of formats to be imported via text file.';
$string['inactiveoverridehelp'] = '* Student does not have the correct group or role to view/attempt the lesson';
$string['insertedpage'] = 'Inserted page';
$string['indicator:cognitivedepth'] = 'Lesson cognitive';
$string['indicator:cognitivedepth_help'] = 'This indicator is based on the cognitive depth reached by the student in a Lesson activity.';
$string['indicator:socialbreadth'] = 'Lesson social';
$string['indicator:socialbreadth_help'] = 'This indicator is based on the social breadth reached by the student in a Lesson activity.';
$string['invalidfile'] = 'Invalid file';
$string['invalidid'] = 'No course module ID or lesson ID were passed';
$string['invalidlessonid'] = 'lesson ID was incorrect';
$string['invalidoverrideid'] = 'Invalid override id';
$string['invalidpageid'] = 'Invalid page ID';
$string['jump'] = 'Jump';
$string['jumps'] = 'Jumps';
$string['jumps_help'] = 'Each answer (for questions) or description (for content pages) has a corresponding jump. The jump can be relative, such as this page or next page, or absolute, specifying any one of the pages in the lesson.';
$string['jumpsto'] = 'Jumps to <em>{$a}</em>';
$string['leftduringtimedsession'] = 'You have left during a timed lesson.';
$string['leftduringtimed'] = 'You have left during a timed lesson.<br />Please click on Continue to restart the lesson.';
$string['leftduringtimednoretake'] = 'You have left during a timed lesson and you are<br />not allowed to retake or continue the lesson.';
$string['lesson:addinstance'] = 'Add a new lesson';
$string['lesson:grade'] = 'Grade lesson essay questions';
$string['lessonclosed'] = 'This lesson closed on {$a}.';
$string['lessoncloses'] = 'Lesson closes';
$string['lessoneventcloses'] = '{$a} closes';
$string['lessoncloseson'] = 'Lesson closes on {$a}';
$string['lesson:edit'] = 'Edit a lesson activity';
$string['lessonformating'] = 'Lesson formatting';
$string['lesson:manage'] = 'Manage a lesson activity';
$string['lesson:manageoverrides'] = 'Manage lesson overrides';
$string['lesson:view'] = 'View lesson activity';
$string['lesson:viewreports'] = 'View lesson reports';
$string['lessonname'] = 'Lesson: {$a}';
$string['lessonmenu'] = 'Lesson menu';
$string['lessonnotready'] = 'This lesson is not ready to be taken.  Please contact your {$a}.';
$string['lessonnotready2'] = 'This lesson is not ready to be taken.';
$string['lessonopen'] = 'This lesson will be open on {$a}.';
$string['lessonopens'] = 'Lesson opens';
$string['lessoneventopens'] = '{$a} opens';
$string['lessonpagelinkingbroken'] = 'First page not found.  Lesson page linking must be broken.  Please contact an admin.';
$string['lessonstats'] = 'Lesson statistics';
$string['linkedmedia'] = 'Linked media';
$string['loginfail'] = 'Login failed, please try again...';
$string['lowscore'] = 'Low score';
$string['lowtime'] = 'Low time';
$string['manualgrading'] = 'Grade essays';
$string['matchesanswer'] = 'Matches with answer';
$string['matching'] = 'Matching';
$string['matchingpair'] = 'Matching pair {$a}';
$string['maxgrade'] = 'Maximum grade';
$string['maxgrade_help'] = 'This setting specifies the maximum grade for the lesson. If set to 0, the lesson does not appear in the grades pages.';
$string['maximumnumberofanswersbranches'] = 'Maximum number of answers';
$string['maximumnumberofanswersbranches_help'] = 'This setting specifies the maximum number of answers that may be used in the lesson. If only true/false questions are used, it can be set to 2. The setting may be changed at any time, since it only affects what the teacher sees, not the data.';
$string['maximumnumberofattempts'] = 'Maximum number of attempts';
$string['maximumnumberofattempts_help'] = 'This setting specifies the maximum number of attempts allowed for each question. If answered incorrectly repeatedly, when the maximum is reached, the next page of the lesson is displayed.';
$string['maximumnumberofattemptsreached'] = 'Maximum number of attempts reached - Moving to next page';
$string['mediaclose'] = 'Show close button';
$string['mediafile'] = 'Linked media';
$string['mediafile_help'] = 'A media file may be uploaded for use in the lesson. A \'Click here to view\' link will then be displayed in a block called \'Linked media\' on each page of the lesson.';
$string['mediafilepopup'] = 'Click here to view';
$string['mediaheight'] = 'Popup window height';
$string['mediawidth'] = 'Popup window width';
$string['messageprovider:graded_essay'] = 'Lesson essay graded notification';
$string['minimumnumberofquestions'] = 'Minimum number of questions';
$string['minimumnumberofquestions_help'] = 'This setting specifies the minimum number of questions that will be used to calculate a grade for the activity.';
$string['missingname'] = 'Please enter a nickname';
$string['modattempts'] = 'Allow student review';
$string['modattempts_help'] = 'If enabled, students can navigate through the lesson again from the start.';
$string['modattemptsnoteacher'] = 'Student review only works for students.';
$string['modulename'] = 'Lesson';
$string['modulename_help'] = 'The lesson activity module enables a teacher to deliver content and/or practice activities in  interesting and flexible ways. A teacher can use the lesson to create a linear set of content pages or instructional activities that offer a variety of paths or options for the learner. In either case, teachers can choose to increase engagement and ensure understanding by including a variety of questions, such as multiple choice, matching and short answer. Depending on the student\'s choice of answer and how the teacher develops the lesson, students may progress to the next page, be taken back to a previous page or redirected down a different path entirely.

A lesson may be graded, with the grade recorded in the gradebook.

Lessons may be used

* For self-directed learning of a new topic
* For  scenarios or simulations/decision-making exercises
* For differentiated revision, with different sets of revision questions depending upon answers given to initial questions';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Lessons';
$string['move'] = 'Move page';
$string['movedpage'] = 'Moved page';
$string['movepagehere'] = 'Move page to here';
$string['movepagenamed'] = 'Move page: {$a}';
$string['moving'] = 'Moving page: {$a}';
$string['multianswer'] = 'Multiple-answer';
$string['multianswer_help'] = 'Tick the checkbox if more than one response is a correct answer.';
$string['multichoice'] = 'Multichoice';
$string['multipleanswer'] = 'Multiple answer';
$string['nameapproved'] = 'Name approved';
$string['namereject'] = 'Sorry, your name has been rejected by the filter.<br />Please try another name.';
$string['new'] = 'new';
$string['nextpage'] = 'Next page';
$string['noanswer'] = 'One or more questions have no answer given.  Please go back and submit an answer.';
$string['noattemptrecordsfound'] = 'No attempt records found: no grade given';
$string['nobranchtablefound'] = 'No content page found';
$string['noclose'] = 'No close date';
$string['nocommentyet'] = 'No comment yet.';
$string['nocoursemods'] = 'No activities found';
$string['nocredit'] = 'No credit';
$string['nodeadline'] = 'No deadline';
$string['noessayquestionsfound'] = 'No essay questions found in this lesson.';
$string['nohighscores'] = 'No high scores';
$string['nolessonattempts'] = 'No attempts have been made on this lesson.';
$string['nolessonattemptsgroup'] = 'No attempts have been made by {$a} group members on this lesson.';
$string['none'] = 'None';
$string['nooneansweredcorrectly'] = 'No one answered correctly.';
$string['nooneansweredthisquestion'] = 'No one answered this question.';
$string['nooneenteredthis'] = 'No one entered this.';
$string['noonehasanswered'] = 'No one has answered an essay question yet.';
$string['noonehasansweredgroup'] = 'No one in {$a} has answered an essay question yet.';
$string['noonecheckedthis'] = 'No one checked this.';
$string['noopen'] = 'No open date';
$string['nooverridedata'] = 'You must override at least one of the lesson settings.';
$string['noretake'] = 'You are not allowed to retake this lesson.';
$string['normal'] = 'Normal - follow lesson path';
$string['notcompleted'] = 'Not completed';
$string['notyetcompleted'] = 'Lesson has been started, but not yet completed';
$string['notdefined'] = 'Not defined';
$string['notenoughsubquestions'] = 'Not enough sub-questions have been defined!';
$string['notenoughtimespent'] = 'You completed this lesson in {$a->timespent}, which is less than the required time of {$a->timerequired}. You might need to attempt the lesson again.';
$string['notgraded'] = 'Not graded';
$string['notitle'] = 'No title';
$string['numberofcorrectanswers'] = 'Number of correct answers: {$a}';
$string['numberofcorrectanswersheader'] = 'Number of correct answers';
$string['numberofcorrectmatches'] = 'Number of correct matches: {$a}';
$string['numberofpagestoshow'] = 'Number of pages to show';
$string['numberofpagestoshow_help'] = 'This setting specifies the number of pages shown in a lesson. It is only applicable for lessons with pages shown in a random order (when "Action after correct answer" is set to "Show an unseen page" or "Show an unanswered page"). If set to zero, then all pages are shown.';
$string['numberofpagesviewed'] = 'Number of questions answered: {$a}';
$string['numberofpagesviewedheader'] = 'Number of questions answered';
$string['numberofpagesviewednotice'] = 'Number of questions answered: {$a->nquestions} (You should answer at least {$a->minquestions})';
$string['numerical'] = 'Numerical';
$string['offlinedatamessage'] = 'You have worked on this attempt using a mobile device. Data was last saved to this site {$a} ago. Please check that you do not have any unsaved work.';
$string['ongoing'] = 'Display ongoing score';
$string['ongoing_help'] = 'If enabled, each page will display the student\'s current points earned out of the total possible thus far.';
$string['ongoingcustom'] = 'You have earned {$a->score} point(s) out of {$a->currenthigh} point(s) thus far.';
$string['ongoingnormal'] = 'You have answered {$a->correct} correctly out of {$a->viewed} attempts.';
$string['onpostperpage'] = 'Only one posting per grade';
$string['openafterclose'] = 'You have specified an open date after the close date';
$string['options'] = 'Options';
$string['or'] = 'OR';
$string['ordered'] = 'Ordered';
$string['other'] = 'Other';
$string['outof'] = 'Out of {$a}';
$string['override'] = 'Override';
$string['overridedeletegroupsure'] = 'Are you sure you want to delete the override for group {$a}?';
$string['overridedeleteusersure'] = 'Are you sure you want to delete the override for user {$a}?';
$string['overridegroup'] = 'Override group';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Overrides';
$string['overrideuser'] = 'Override user';
$string['overrideusereventname'] = '{$a->lesson} - Override';
$string['overview'] = 'Overview';
$string['overview_help'] = 'A lesson is made up of a number of pages and optionally content pages. A page contains some content and usually ends with a question. Associated with each answer to the question is a jump. The jump can be relative, such as this page or next page, or absolute, specifying any one of the pages in the lesson. A content page is a page containing a set of links to other pages in the lesson, for example a Table of Contents.';
$string['page'] = 'Page: {$a}';
$string['page-mod-lesson-x'] = 'Any lesson page';
$string['page-mod-lesson-view'] = 'View or preview lesson page';
$string['page-mod-lesson-edit'] = 'Edit lesson page';
$string['pageanswers'] = 'Page answers';
$string['pagecontents'] = 'Page contents';
$string['pageresponses'] = 'Page responses';
$string['pages'] = 'Pages';
$string['pagetitle'] = 'Page title';
$string['password'] = 'Password';
$string['passwordprotectedlesson'] = '{$a} is a password protected lesson.';
$string['pleaseenteryouranswerinthebox'] = 'Please enter your answer in the box';
$string['pleasecheckoneanswer'] = 'Please check one answer';
$string['pleasecheckoneormoreanswers'] = 'Please check one or more answers';
$string['pleasematchtheabovepairs'] = 'Please match the above pairs';
$string['pluginadministration'] = 'Lesson administration';
$string['pluginname'] = 'Lesson';
$string['pointsearned'] = 'Points earned';
$string['postprocesserror'] = 'Error occurred during post-processing!';
$string['postsuccess'] = 'Post successful';
$string['practice'] = 'Practice lesson';
$string['practice_help'] = 'A practice lesson does not appear in the gradebook.';
$string['preprocesserror'] = 'Error occurred during pre-processing!';
$string['prerequisiteisobsolete'] = 'The prerequisite lesson option is due to be removed. Please use access restrictions instead.';
$string['prerequisitelesson'] = 'Prerequisite lesson';
$string['preview'] = 'Preview';
$string['previewlesson'] = 'Preview {$a}';
$string['previewpagenamed'] = 'Preview page: {$a}';
$string['previouspage'] = 'Previous page';
$string['privacy:metadata:attempts:userid'] = 'The user ID';
$string['privacy:metadata:attempts:pageid'] = 'The page ID';
$string['privacy:metadata:attempts:answerid'] = 'The answer ID';
$string['privacy:metadata:attempts:retry'] = 'The attempt number';
$string['privacy:metadata:attempts:correct'] = 'Whether the attempt was correct';
$string['privacy:metadata:attempts:useranswer'] = 'Details about the user\'s answer';
$string['privacy:metadata:attempts:timeseen'] = 'The time when the attempt was made';
$string['privacy:metadata:attempts'] = 'A record of page attempts';
$string['privacy:metadata:grades:userid'] = 'The user ID';
$string['privacy:metadata:grades:grade'] = 'The grade given';
$string['privacy:metadata:grades:completed'] = 'The date when the grade was given';
$string['privacy:metadata:grades'] = 'A record of the grades for each lesson';
$string['privacy:metadata:timer:userid'] = 'The user ID';
$string['privacy:metadata:timer:starttime'] = 'The date when the attempt started';
$string['privacy:metadata:timer:lessontime'] = 'The last moment when we recorded activity';
$string['privacy:metadata:timer:completed'] = 'Whether the attempt is complete';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'The last moment when we recorded activity from the mobile app';
$string['privacy:metadata:timer'] = 'A record of a lesson attempt';
$string['privacy:metadata:branch:userid'] = 'The user ID';
$string['privacy:metadata:branch:pageid'] = 'The page ID';
$string['privacy:metadata:branch:retry'] = 'The attempt number';
$string['privacy:metadata:branch:flag'] = 'Whether the next page was calculated randomely';
$string['privacy:metadata:branch:timeseen'] = 'The time when the page was viewed';
$string['privacy:metadata:branch:nextpageid'] = 'The next page ID';
$string['privacy:metadata:branch'] = 'A record of the pages viewed';
$string['privacy:metadata:overrides:userid'] = 'The user ID';
$string['privacy:metadata:overrides:available'] = 'The time when the lesson may be attempted';
$string['privacy:metadata:overrides:deadline'] = 'The deadline for completing the lesson.';
$string['privacy:metadata:overrides:timelimit'] = 'Time limit to complete the lesson, in seconds.';
$string['privacy:metadata:overrides:review'] = 'Whether trying a question again is allowed';
$string['privacy:metadata:overrides:maxattempts'] = 'The maximium number of attempts';
$string['privacy:metadata:overrides:retake'] = 'Whether re-takes are allowed';
$string['privacy:metadata:overrides:password'] = 'The password to access the lesson';
$string['privacy:metadata:overrides'] = 'A record of overrides per lesson';
$string['privacy:metadata:userpref:lessonview'] = 'The preferred display mode when editing lessons';
$string['privacy:path:essayresponses'] = 'Essay responses';
$string['privacy:path:pages'] = 'Pages';
$string['processerror'] = 'Error occurred during processing!';
$string['progressbar'] = 'Progress bar';
$string['progressbar_help'] = 'If enabled, a bar is displayed at the bottom of lesson pages showing approximate percentage of completion.';
$string['progresscompleted'] = 'You have completed {$a}% of the lesson';
$string['progressbarteacherwarning'] = 'Progress bar does not display for {$a}';
$string['progressbarteacherwarning2'] = 'You will not see the progress bar because you can edit this lesson';
$string['qtype'] = 'Page type';
$string['question'] = 'Question';
$string['questionoption'] = 'Question';
$string['questiontype'] = 'Question type';
$string['randombranch'] = 'Random content page';
$string['randompageinbranch'] = 'Random question within a content page';
$string['rank'] = 'Rank';
$string['rawgrade'] = 'Raw grade';
$string['receivedcredit'] = 'Received credit';
$string['redisplaypage'] = 'Redisplay page';
$string['removeallgroupoverrides'] = 'Delete all group overrides';
$string['removealluseroverrides'] = 'Delete all user overrides';
$string['report'] = 'Report';
$string['reports'] = 'Reports';
$string['response'] = 'Response';
$string['retakesallowed'] = 'Re-takes allowed';
$string['retakesallowed_help'] = 'If enabled, students can attempt the lesson more than once.';
$string['returnto'] = 'Return to {$a}';
$string['returntocourse'] = 'Return to the course';
$string['reverttodefaults'] = 'Revert to lesson defaults';
$string['review'] = 'Review';
$string['reviewlesson'] = 'Review lesson';
$string['reviewquestionback'] = 'Yes, I\'d like to try again';
$string['reviewquestioncontinue'] = 'No, I just want to go on to the next question';
$string['sanitycheckfailed'] = 'Sanity check failed: This attempt has been deleted';
$string['save'] = 'Save';
$string['savechanges'] = 'Save changes';
$string['savechangesandeol'] = 'Save all changes and go to the end of the lesson.';
$string['saveoverrideandstay'] = 'Save and enter another override';
$string['savepage'] = 'Save page';
$string['score'] = 'Score';
$string['score_help'] = 'Score is only used when custom scoring is enabled. Each answer can then be given a numerical point value (positive or negative).';
$string['scores'] = 'Scores';
$string['search:activity'] = 'Lesson - activity information';
$string['secondpluswrong'] = 'Not quite.  Would you like to try again?';
$string['selectaqtype'] = 'Select a question type';
$string['sent'] = 'Sent';
$string['shortanswer'] = 'Short answer';
$string['showanunansweredpage'] = 'Show an unanswered page';
$string['showanunseenpage'] = 'Show an unseen page';
$string['singleanswer'] = 'Single answer';
$string['skip'] = 'Skip navigation';
$string['slideshow'] = 'Slideshow';
$string['slideshow_help'] = 'If enabled, the lesson is displayed as a slideshow, with a fixed width and height.';
$string['slideshowbgcolor'] = 'Slideshow background colour';
$string['slideshowheight'] = 'Slideshow height';
$string['slideshowwidth'] = 'Slideshow width';
$string['startlesson'] = 'Start lesson';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname}\'s attempt number {$a->attempt}';
$string['studentname'] = '{$a} Name';
$string['studentoneminwarning'] = 'Warning: You have 1 minute or less to finish the lesson.';
$string['studentoutoftimeforreview'] = 'Attention: You ran out of time for reviewing this lesson';
$string['studentresponse'] = '{$a}\'s response';
$string['submit'] = 'Submit';
$string['submitname'] = 'Submit name';
$string['teacherjumpwarning'] = 'An {$a->cluster} jump or an {$a->unseen} jump is being used in this lesson.  The next page jump will be used instead.  Login as a student to test these jumps.';
$string['teacherongoingwarning'] = 'Ongoing score is only displayed for student.  Login as a student to test ongoing score';
$string['teachertimerwarning'] = 'Timer only works for students.  Test the timer by logging in as a student.';
$string['thatsthecorrectanswer'] = 'That\'s the correct answer';
$string['thatsthewronganswer'] = 'That\'s the wrong answer';
$string['thefollowingpagesjumptothispage'] = 'The following pages jump to this page';
$string['thispage'] = 'This page';
$string['timeisup'] = 'Time is up';
$string['timelimit'] = 'Time limit';
$string['timelimit_help'] = 'If enabled, a warning about the time limit is displayed at the beginning of the lesson and a countdown timer is displayed. Any answers given after the time has elapsed are not graded.';
$string['timelimitwarning'] = 'You have {$a} to finish the lesson.';
$string['timeremaining'] = 'Time remaining';
$string['timespenterror'] = 'Spend at least {$a} minutes in the lesson';
$string['timespentminutes'] = 'Time spent (minutes)';
$string['timetaken'] = 'Time taken';
$string['totalpagesviewedheader'] = 'Number of pages viewed';
$string['true'] = 'True';
$string['truefalse'] = 'True/false';
$string['unabledtosavefile'] = 'The file you uploaded could not be saved';
$string['unknownqtypesnotimported'] = '{$a} questions with unsupported question types were not imported';
$string['unseenpageinbranch'] = 'Unseen question within a content page';
$string['unsupportedqtype'] = 'Unsupported question type ({$a})!';
$string['updatepagenamed'] = 'Update page: {$a}';
$string['updatedpage'] = 'Updated page';
$string['updatefailed'] = 'Update failed';
$string['usemaximum'] = 'Use maximum';
$string['usemean'] = 'Use mean';
$string['usepassword'] = 'Password protected lesson';
$string['usepassword_help'] = 'If enabled, a password is required in order to access the lesson.';
$string['useroverrides'] = 'User overrides';
$string['useroverridesdeleted'] = 'User overrides deleted';
$string['usersnone'] = 'No students have access to this lesson';
$string['viewessayanswers'] = 'View essay answers';
$string['viewgrades'] = 'View grades';
$string['viewreports'] = 'View {$a->attempts} completed {$a->student} attempts';
$string['viewreports2'] = 'View {$a} completed attempts';
$string['warning'] = 'Warning';
$string['welldone'] = 'Well done!';
$string['whatdofirst'] = 'What would you like to do first?';
$string['wronganswerjump'] = 'Wrong answer jump';
$string['wronganswerscore'] = 'Wrong answer score';
$string['wrongresponse'] = 'Wrong response';
$string['xattempts'] = '{$a} attempts';
$string['youhaveseen'] = 'You have seen more than one page of this lesson already.<br />Do you want to start at the last page you saw?';
$string['youranswer'] = 'Your answer';
$string['yourcurrentgradeis'] = 'Your current grade is {$a}';
$string['yourcurrentgradeisoutof'] = 'Your current grade is {$a->grade} out of {$a->total}';
$string['youshouldview'] = 'You should answer at least: {$a}';

